/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.condition.CompoundCondition;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.ManaWasSpentCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CankerousThirstEffect
extends OneShotEffect {
    private static final Condition condition = new CompoundCondition(new Condition[]{ManaWasSpentCondition.BLACK, ManaWasSpentCondition.RED});

    public CankerousThirstEffect() {
        super(Outcome.Benefit);
        this.staticText = "If {B} was spent to cast this spell, you may have target creature get -3/-3 until end of turn. If {G} was spent to cast this spell, you may have target creature get +3/+3 until end of turn";
    }

    private CankerousThirstEffect(CankerousThirstEffect effect) {
        super((OneShotEffect)effect);
    }

    public CankerousThirstEffect copy() {
        return new CankerousThirstEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent targetCreature2;
            BoostTargetEffect effect;
            Permanent targetCreature1;
            if (ManaWasSpentCondition.BLACK.apply(game, source) && (targetCreature1 = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null && controller.chooseUse(Outcome.UnboostCreature, "Let " + targetCreature1.getIdName() + " get -3/-3 until end of turn?", source, game)) {
                effect = new BoostTargetEffect(-3, -3, Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(targetCreature1, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            if (ManaWasSpentCondition.GREEN.apply(game, source) && (targetCreature2 = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null && controller.chooseUse(Outcome.UnboostCreature, "Let " + targetCreature2.getIdName() + " get +3/+3 until end of turn?", source, game)) {
                effect = new BoostTargetEffect(3, 3, Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(targetCreature2, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }

    public Condition getCondition() {
        return condition;
    }
}

