/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.CanoptekWraithPredicate;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInLibrary;

class CanoptekWraithEffect
extends OneShotEffect {
    CanoptekWraithEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a land you control. Then search your library for up to two basic land cards which have the same name as the chosen land, put them onto the battlefield tapped, then shuffle";
    }

    private CanoptekWraithEffect(CanoptekWraithEffect effect) {
        super((OneShotEffect)effect);
    }

    public CanoptekWraithEffect copy() {
        return new CanoptekWraithEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source, game, 1)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        FilterLandCard filter = new FilterLandCard("basic land cards with the same name as the chosen land");
        filter.add((Predicate)SuperType.BASIC.getPredicate());
        filter.add((Predicate)new CanoptekWraithPredicate(permanent));
        TargetCardInLibrary targetCard = new TargetCardInLibrary(0, 2, (FilterCard)filter);
        player.searchLibrary(targetCard, source, game);
        Set cards = targetCard.getTargets().stream().map(uuid -> player.getLibrary().getCard(uuid, game)).filter(Objects::nonNull).collect(Collectors.toSet());
        player.moveCards(cards, Zone.BATTLEFIELD, source, game, true, false, false, null);
        player.shuffleLibrary(source, game);
        return true;
    }
}

