/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CanopyGargantuanEffect
extends OneShotEffect {
    CanopyGargantuanEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a number of +1/+1 counters on each other creature you control equal to that creature's toughness";
    }

    private CanopyGargantuanEffect(CanopyGargantuanEffect effect) {
        super((OneShotEffect)effect);
    }

    public CanopyGargantuanEffect copy() {
        return new CanopyGargantuanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_OTHER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            int toughness = permanent.getToughness().getValue();
            if (toughness <= 0) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(toughness), source, game);
        }
        return true;
    }
}

