/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.CarpetOfFlowersEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class CarpetOfFlowersTriggeredAbility
extends TriggeredAbilityImpl {
    CarpetOfFlowersTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CarpetOfFlowersEffect(), true);
        this.addTarget((Target)new TargetOpponent());
        this.setTriggerPhrase("At the beginning of each of your main phases, if you haven't added mana with this ability this turn, ");
    }

    private CarpetOfFlowersTriggeredAbility(CarpetOfFlowersTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CarpetOfFlowersTriggeredAbility copy() {
        return new CarpetOfFlowersTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PRECOMBAT_MAIN_PHASE_PRE || event.getType() == GameEvent.EventType.POSTCOMBAT_MAIN_PHASE_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getPlayerId().equals(this.controllerId);
    }

    public boolean checkInterveningIfClause(Game game) {
        return !Boolean.TRUE.equals(game.getState().getValue(this.getOriginalId().toString() + "addMana" + game.getState().getZoneChangeCounter(this.sourceId)));
    }

    public boolean resolve(Game game) {
        boolean value = super.resolve(game);
        if (value) {
            game.getState().setValue(this.getOriginalId().toString() + "addMana" + game.getState().getZoneChangeCounter(this.sourceId), (Object)Boolean.TRUE);
        }
        return value;
    }

    public void reset(Game game) {
        game.getState().setValue(this.getOriginalId().toString() + "addMana" + game.getState().getZoneChangeCounter(this.sourceId), (Object)Boolean.FALSE);
    }
}

