/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AssignNoCombatDamageSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;

class CarrionWurmEffect
extends OneShotEffect {
    CarrionWurmEffect() {
        super(Outcome.Neutral);
        this.staticText = "any player may exile three cards from their graveyard. If a player does, {this} assigns no combat damage this turn";
    }

    private CarrionWurmEffect(CarrionWurmEffect effect) {
        super((OneShotEffect)effect);
    }

    public CarrionWurmEffect copy() {
        return new CarrionWurmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null) {
            return false;
        }
        ExileFromGraveCost cost = new ExileFromGraveCost(new TargetCardInYourGraveyard(3));
        String message = "Exile three cards from your graveyard to have " + permanent.getIdName() + " assign no combat damage?";
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            cost.clearPaid();
            if (player == null || !player.canRespond() || !cost.canPay(source, source, playerId, game) || !player.chooseUse(Outcome.Benefit, message, source, game) || !cost.pay(source, game, source, playerId, false, null)) continue;
            if (!game.isSimulation()) {
                game.informPlayers(player.getLogName() + " exiles three cards to have " + permanent.getLogName() + " assign no combat damage.");
            }
            game.addEffect((ContinuousEffect)new AssignNoCombatDamageSourceEffect(Duration.EndOfTurn), source);
            break;
        }
        return true;
    }
}

