/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class CartographersHawkEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a Plains card");

    CartographersHawkEffect() {
        super(Outcome.Benefit);
    }

    private CartographersHawkEffect(CartographersHawkEffect effect) {
        super((OneShotEffect)effect);
    }

    public CartographersHawkEffect copy() {
        return new CartographersHawkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        Player player = game.getPlayer(source.getControllerId());
        if (permanent == null || player == null) {
            return false;
        }
        if (!player.moveCards((Card)permanent, Zone.HAND, source, game)) {
            return false;
        }
        if (!player.chooseUse(Outcome.PutLandInPlay, "Search your library for Plains card?", source, game)) {
            return true;
        }
        return new SearchLibraryPutInPlayEffect(new TargetCardInLibrary(filter), true).apply(game, source);
    }

    static {
        filter.add((Predicate)SubType.PLAINS.getPredicate());
    }
}

