/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.ManaPoolItem;
import mage.util.CardUtil;

class CaseFileAuditorManaEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    CaseFileAuditorManaEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "you may spend mana as though it were mana of any color to cast Case spells";
    }

    private CaseFileAuditorManaEffect(CaseFileAuditorManaEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public CaseFileAuditorManaEffect copy() {
        return new CaseFileAuditorManaEffect(this);
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        return mana.getFirstAvailable();
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId)) {
            return false;
        }
        MageObject mageObject = game.getObject(CardUtil.getMainCardId((Game)game, (UUID)objectId));
        return mageObject != null && mageObject.hasSubtype(SubType.CASE, game);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }
}

