/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CaseOfTheGatewayExpressEffect
extends OneShotEffect {
    CaseOfTheGatewayExpressEffect() {
        super(Outcome.Damage);
        this.staticText = "choose target creature you don't control. Each creature you control deals 1 damage to that creature.";
    }

    private CaseOfTheGatewayExpressEffect(CaseOfTheGatewayExpressEffect effect) {
        super((OneShotEffect)effect);
    }

    public CaseOfTheGatewayExpressEffect copy() {
        return new CaseOfTheGatewayExpressEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            if (creature == null) continue;
            permanent.damage(1, creature.getId(), source, game);
        }
        return true;
    }
}

