/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CaseOfThePilferedProofTriggeredAbility
extends TriggeredAbilityImpl {
    CaseOfThePilferedProofTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()).setText("put a +1/+1 counter on it"));
        this.setTriggerPhrase("Whenever a Detective you control enters and whenever a Detective you control is turned face up, ");
    }

    private CaseOfThePilferedProofTriggeredAbility(CaseOfThePilferedProofTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CaseOfThePilferedProofTriggeredAbility copy() {
        return new CaseOfThePilferedProofTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: 
            case TURNED_FACE_UP: {
                return true;
            }
        }
        return false;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.hasSubtype(SubType.DETECTIVE, game) && permanent.isControlledBy(this.getControllerId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            return true;
        }
        return false;
    }
}

