/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class CaseOfTheRansackedLabWatcher
extends Watcher {
    private final Map<UUID, Integer> instantSorceryCount = new HashMap<UUID, Integer>();

    CaseOfTheRansackedLabWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST) {
            Spell spell = game.getStack().getSpell(event.getTargetId());
            if (spell == null || !spell.isInstantOrSorcery(game)) {
                return;
            }
            this.instantSorceryCount.putIfAbsent(spell.getControllerId(), 0);
            this.instantSorceryCount.compute(spell.getControllerId(), (k, a) -> a + 1);
        }
    }

    public void reset() {
        super.reset();
        this.instantSorceryCount.clear();
    }

    int getInstantSorceryCount(UUID playerId) {
        return this.instantSorceryCount.getOrDefault(playerId, 0);
    }
}

