/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledEnchantmentPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterControlledPlaneswalkerPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class CataclysmicGearhulkEffect
extends OneShotEffect {
    private static final FilterControlledArtifactPermanent filterArtifact = new FilterControlledArtifactPermanent("artifact");
    private static final FilterControlledCreaturePermanent filterCreature = new FilterControlledCreaturePermanent("creature");
    private static final FilterControlledEnchantmentPermanent filterEnchantment = new FilterControlledEnchantmentPermanent("enchantment");
    private static final FilterControlledPlaneswalkerPermanent filterPlaneswalker = new FilterControlledPlaneswalkerPermanent("planeswalker");

    public CataclysmicGearhulkEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "each player chooses an artifact, a creature, an enchantment, and a planeswalker from among the nonland permanents they control, then sacrifices the rest";
    }

    private CataclysmicGearhulkEffect(CataclysmicGearhulkEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> chosen = new ArrayList<Permanent>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            TargetControlledPermanent target1 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)filterArtifact, true);
            TargetControlledPermanent target2 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)filterCreature, true);
            TargetControlledPermanent target3 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)filterEnchantment, true);
            TargetControlledPermanent target4 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)filterPlaneswalker, true);
            if (target1.canChoose(player.getId(), source, game)) {
                while (player.canRespond() && !target1.isChosen(game) && target1.canChoose(player.getId(), source, game)) {
                    player.chooseTarget(Outcome.Benefit, (Target)target1, source, game);
                }
                Permanent artifact = game.getPermanent(target1.getFirstTarget());
                if (artifact != null) {
                    chosen.add(artifact);
                }
                target1.clearChosen();
            }
            if (target2.canChoose(player.getId(), source, game)) {
                while (player.canRespond() && !target2.isChosen(game) && target2.canChoose(player.getId(), source, game)) {
                    player.chooseTarget(Outcome.Benefit, (Target)target2, source, game);
                }
                Permanent creature = game.getPermanent(target2.getFirstTarget());
                if (creature != null) {
                    chosen.add(creature);
                }
                target2.clearChosen();
            }
            if (target3.canChoose(player.getId(), source, game)) {
                while (player.canRespond() && !target3.isChosen(game) && target3.canChoose(player.getId(), source, game)) {
                    player.chooseTarget(Outcome.Benefit, (Target)target3, source, game);
                }
                Permanent enchantment = game.getPermanent(target3.getFirstTarget());
                if (enchantment != null) {
                    chosen.add(enchantment);
                }
                target3.clearChosen();
            }
            if (!target4.canChoose(player.getId(), source, game)) continue;
            while (player.canRespond() && !target4.isChosen(game) && target4.canChoose(player.getId(), source, game)) {
                player.chooseTarget(Outcome.Benefit, (Target)target4, source, game);
            }
            Permanent planeswalker = game.getPermanent(target4.getFirstTarget());
            if (planeswalker != null) {
                chosen.add(planeswalker);
            }
            target4.clearChosen();
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents()) {
            if (chosen.contains(permanent) || permanent.isLand(game)) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }

    public CataclysmicGearhulkEffect copy() {
        return new CataclysmicGearhulkEffect(this);
    }

    static {
        filterArtifact.add(Predicates.and((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)Predicates.not((Predicate)CardType.LAND.getPredicate())));
        filterCreature.add(Predicates.and((Predicate)CardType.CREATURE.getPredicate(), (Predicate)Predicates.not((Predicate)CardType.LAND.getPredicate())));
        filterEnchantment.add(Predicates.and((Predicate)CardType.ENCHANTMENT.getPredicate(), (Predicate)Predicates.not((Predicate)CardType.LAND.getPredicate())));
        filterPlaneswalker.add(Predicates.and((Predicate)CardType.PLANESWALKER.getPredicate(), (Predicate)Predicates.not((Predicate)CardType.LAND.getPredicate())));
    }
}

