/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CatacombDragonEffect
extends OneShotEffect {
    CatacombDragonEffect() {
        super(Outcome.Benefit);
        this.staticText = "that creature gets -X/-0 until end of turn, where X is half the creature's power, rounded down.";
    }

    private CatacombDragonEffect(CatacombDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public CatacombDragonEffect copy() {
        return new CatacombDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || !permanent.isCreature(game)) {
            return false;
        }
        int unBoost = -1 * Math.floorDiv(permanent.getPower().getValue(), 2);
        game.addEffect((ContinuousEffect)new BoostTargetEffect(unBoost, 0), source);
        return true;
    }
}

