/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class Celebr8000Effect
extends OneShotEffect {
    private static final ContinuousEffect[] d6_effects = new ContinuousEffect[]{null, new BoostSourceEffect(1, 1, Duration.EndOfTurn), new GainAbilitySourceEffect((Ability)new MenaceAbility(), Duration.EndOfTurn), new GainAbilitySourceEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn), new GainAbilitySourceEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn), new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn), new GainAbilitySourceEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn)};
    private static final ContinuousEffect doubles_effect = new GainAbilitySourceEffect((Ability)DoubleStrikeAbility.getInstance(), Duration.EndOfTurn);

    Celebr8000Effect() {
        super(Outcome.Benefit);
        this.setText("roll two six-sided dice. For each result of 1, {this} gets +1/+1 until end of turn. For each other result, it gains the indicated ability until end of turn. If you rolled doubles, it also gains double strike until end of turn.<br>&bull; 2 \u2014 menace<br>&bull; 3 \u2014 vigilance<br>&bull; 4 \u2014 lifelink<br>&bull; 5 \u2014 flying<br>&bull; 6 \u2014 indestructible");
    }

    private Celebr8000Effect(Celebr8000Effect effect) {
        super((OneShotEffect)effect);
    }

    public Celebr8000Effect copy() {
        return new Celebr8000Effect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List results = player.rollDice(this.outcome, source, game, 6, 2, 0);
        int roll1 = (Integer)results.get(0);
        int roll2 = (Integer)results.get(1);
        if (roll1 >= 1 && roll1 <= 6) {
            game.addEffect(d6_effects[roll1], source);
        }
        if (roll2 >= 1 && roll2 <= 6) {
            game.addEffect(d6_effects[roll2], source);
        }
        if (roll1 == roll2) {
            game.addEffect(doubles_effect, source);
        }
        return true;
    }
}

