/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class CelestialJudgmentEffect
extends OneShotEffect {
    CelestialJudgmentEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each different power among creatures on the battlefield, choose a creature with that power. Destroy each creature not chosen this way";
    }

    private CelestialJudgmentEffect(CelestialJudgmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public CelestialJudgmentEffect copy() {
        return new CelestialJudgmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game);
        Map<Integer, List> powerMap = permanents.stream().collect(Collectors.toMap(permanent -> permanent.getPower().getValue(), xva$0 -> Arrays.asList(xva$0), (a1, a2) -> {
            ArrayList res = new ArrayList();
            res.addAll(a1);
            res.addAll(a2);
            return res;
        }));
        HashSet<UUID> toKeep = new HashSet<UUID>();
        for (Map.Entry<Integer, List> entry : powerMap.entrySet()) {
            if (entry.getValue().size() == 1) {
                toKeep.add(((Permanent)entry.getValue().get(0)).getId());
                continue;
            }
            FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with power " + entry.getKey() + " to save");
            filter.add((Predicate)new PowerPredicate(ComparisonType.EQUAL_TO, entry.getKey().intValue()));
            TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            toKeep.add(target.getFirstTarget());
        }
        for (Permanent permanent2 : permanents) {
            if (toKeep.contains(permanent2.getId())) continue;
            permanent2.destroy(source, game);
        }
        return true;
    }
}

