/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.stack.Spell;

class CelestialKirinEffect
extends OneShotEffect {
    CelestialKirinEffect() {
        super(Outcome.GainLife);
        this.staticText = "destroy all permanents with that spell's mana value";
    }

    private CelestialKirinEffect(CelestialKirinEffect effect) {
        super((OneShotEffect)effect);
    }

    public CelestialKirinEffect copy() {
        return new CelestialKirinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            int cmc = spell.getManaValue();
            FilterPermanent filter = new FilterPermanent();
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, cmc));
            return new DestroyAllEffect(filter).apply(game, source);
        }
        return false;
    }
}

