/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.common.DiesCreatureTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class CemeteryPucaEffect
extends OneShotEffect {
    CemeteryPucaEffect() {
        super(Outcome.Copy);
        this.staticText = "{this} becomes a copy of that creature, except it has this ability";
    }

    private CemeteryPucaEffect(CemeteryPucaEffect effect) {
        super((OneShotEffect)effect);
    }

    public CemeteryPucaEffect copy() {
        return new CemeteryPucaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent copyFromCreature;
        Permanent copyToCreature = game.getPermanent(source.getSourceId());
        if (copyToCreature != null && (copyFromCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source)) != null) {
            game.copyPermanent(Duration.WhileOnBattlefield, copyFromCreature, copyToCreature.getId(), source, (CopyApplier)new EmptyCopyApplier());
            GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)new DiesCreatureTriggeredAbility((Effect)new DoIfCostPaid((Effect)new CemeteryPucaEffect(), (Cost)new ManaCostsImpl("{1}")), false, (FilterPermanent)StaticFilters.FILTER_PERMANENT_A_CREATURE, true), Duration.WhileOnBattlefield);
            effect.setTargetPointer((TargetPointer)new FixedTarget(copyToCreature.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

