/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CerebralEruptionEffect
extends OneShotEffect {
    CerebralEruptionEffect() {
        super(Outcome.Damage);
        this.staticText = "Target opponent reveals the top card of their library. {this} deals damage equal to the revealed card's mana value to that player and each creature they control. If a land card is revealed this way, return {this} to its owner's hand";
    }

    private CerebralEruptionEffect(CerebralEruptionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        MageObject sourceObject = game.getObject(source);
        if (player != null && sourceObject != null && player.getLibrary().hasCards()) {
            Card spellCard;
            Card card = player.getLibrary().getFromTop(game);
            CardsImpl cards = new CardsImpl(card);
            player.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            game.getState().setValue(source.getSourceId().toString(), (Object)card);
            int damage = card.getManaValue();
            player.damage(damage, source.getSourceId(), source, game);
            for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, player.getId(), game)) {
                perm.damage(damage, source.getSourceId(), source, game, false, true);
            }
            if (card.isLand(game) && (spellCard = game.getStack().getSpell(source.getSourceId()).getCard()) != null) {
                player.moveCards(spellCard, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }

    public CerebralEruptionEffect copy() {
        return new CerebralEruptionEffect(this);
    }
}

