/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CertainDeathEffect
extends OneShotEffect {
    CertainDeathEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature. Its controller loses 2 life and you gain 2 life";
    }

    private CertainDeathEffect(CertainDeathEffect effect) {
        super((OneShotEffect)effect);
    }

    public CertainDeathEffect copy() {
        return new CertainDeathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && you != null) {
            permanent.destroy(source, game, false);
            Player permController = game.getPlayer(permanent.getControllerId());
            if (permController != null) {
                permController.loseLife(2, game, source, false);
                you.gainLife(2, game, source);
                return true;
            }
        }
        return false;
    }
}

