/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class ChainOfVaporEffect
extends OneShotEffect {
    ChainOfVaporEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target nonland permanent to its owner's hand. Then that permanent's controller may sacrifice a land of their choice. If the player does, they may copy this spell and may choose a new target for that copy";
    }

    private ChainOfVaporEffect(ChainOfVaporEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChainOfVaporEffect copy() {
        return new ChainOfVaporEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            Spell spell;
            Permanent land;
            controller.moveCards((Card)permanent, Zone.HAND, source, game);
            Player player = game.getPlayer(permanent.getControllerId());
            TargetSacrifice target = new TargetSacrifice(0, 1, (FilterPermanent)new FilterControlledLandPermanent("a land to sacrifice (to be able to copy " + sourceObject.getName() + ')'));
            if (player != null && player.chooseTarget(Outcome.Sacrifice, (Target)target, source, game) && (land = game.getPermanent(target.getFirstTarget())) != null && land.sacrifice(source, game) && player.chooseUse(this.outcome, "Copy the spell?", source, game) && (spell = game.getStack().getSpell(source.getSourceId())) != null) {
                spell.createCopyOnStack(game, source, player.getId(), true);
            }
            return true;
        }
        return false;
    }
}

