/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChainedThroatseekerCantAttackEffect
extends RestrictionEffect {
    ChainedThroatseekerCantAttackEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack unless defending player is poisoned";
    }

    private ChainedThroatseekerCantAttackEffect(ChainedThroatseekerCantAttackEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        Player targetPlayer = game.getPlayerOrPlaneswalkerController(defenderId);
        return targetPlayer != null && targetPlayer.getCountersCount(CounterType.POISON) > 0;
    }

    public ChainedThroatseekerCantAttackEffect copy() {
        return new ChainedThroatseekerCantAttackEffect(this);
    }
}

