/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.abilities.effects.common.continuous.BecomesColorTargetEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTypeTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChainerDementiaMasterEffect
extends OneShotEffect {
    ChainerDementiaMasterEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Put target creature card from a graveyard onto the battlefield under your control. That creature is black and is a Nightmare in addition to its other creature types";
    }

    private ChainerDementiaMasterEffect(ChainerDementiaMasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChainerDementiaMasterEffect copy() {
        return new ChainerDementiaMasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            UUID cardId = this.getTargetPointer().getFirst(game, source);
            new ReturnFromGraveyardToBattlefieldTargetEffect().apply(game, source);
            Permanent permanent = game.getPermanent(cardId);
            if (permanent != null) {
                BecomesColorTargetEffect effect = new BecomesColorTargetEffect(ObjectColor.BLACK, Duration.WhileOnBattlefield);
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
                effect = new BecomesCreatureTypeTargetEffect(Duration.WhileOnBattlefield, SubType.NIGHTMARE, false);
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

