/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldControlledTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;
import mage.watchers.common.CastFromHandWatcher;

class ChainerNightmareAdeptTriggeredAbility
extends EntersBattlefieldControlledTriggeredAbility {
    private static final ContinuousEffect gainHasteUntilNextTurnEffect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.UntilYourNextTurn);

    ChainerNightmareAdeptTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)gainHasteUntilNextTurnEffect, (FilterPermanent)StaticFilters.FILTER_CREATURE_NON_TOKEN, false, SetTargetPointer.PERMANENT);
        this.addWatcher((Watcher)new CastFromHandWatcher());
        this.setTriggerPhrase("Whenever a nontoken creature you control enters, if you didn't cast it from your hand, ");
    }

    private ChainerNightmareAdeptTriggeredAbility(ChainerNightmareAdeptTriggeredAbility effect) {
        super((EntersBattlefieldControlledTriggeredAbility)effect);
    }

    public ChainerNightmareAdeptTriggeredAbility copy() {
        return new ChainerNightmareAdeptTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        CastFromHandWatcher watcher = (CastFromHandWatcher)game.getState().getWatcher(CastFromHandWatcher.class);
        return watcher != null && !watcher.spellWasCastFromHand(event.getTargetId()) && super.checkTrigger(event, game);
    }
}

