/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ChameleonBlurEffect
extends PreventionEffectImpl {
    ChameleonBlurEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false);
        this.staticText = "prevent all damage that creatures would deal to players this turn";
    }

    private ChameleonBlurEffect(ChameleonBlurEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public ChameleonBlurEffect copy() {
        return new ChameleonBlurEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game) && event.getType() == GameEvent.EventType.DAMAGE_PLAYER && event.getAmount() > 0) {
            Permanent permanent = game.getPermanent(event.getSourceId());
            return permanent != null && permanent.isCreature(game);
        }
        return false;
    }
}

