/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ChandraHeartOfFireUltimateEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("red instant or sorcery");

    ChandraHeartOfFireUltimateEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your graveyard and library for any number of red instant and/or sorcery cards, exile them, then shuffle. You may cast them this turn";
    }

    private ChandraHeartOfFireUltimateEffect(ChandraHeartOfFireUltimateEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraHeartOfFireUltimateEffect copy() {
        return new ChandraHeartOfFireUltimateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Set cards;
            HashSet<Card> exiledCards = new HashSet<Card>();
            Target target = new TargetCardInYourGraveyard(0, Integer.MAX_VALUE, filter, true).withChooseHint("from graveyard");
            if (target.canChoose(controller.getId(), source, game) && target.choose(Outcome.AIDontUseIt, controller.getId(), source.getSourceId(), source, game)) {
                cards = new CardsImpl((Collection)target.getTargets()).getCards(game);
                exiledCards.addAll(cards);
            }
            if ((target = new TargetCardInLibrary(0, Integer.MAX_VALUE, filter).withChooseHint("from library")).canChoose(controller.getId(), source, game) && target.choose(Outcome.AIDontUseIt, controller.getId(), source.getSourceId(), source, game)) {
                cards = new CardsImpl((Collection)target.getTargets()).getCards(game);
                exiledCards.addAll(cards);
            }
            controller.moveCardsToExile(exiledCards, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
            controller.shuffleLibrary(source, game);
            exiledCards.removeIf(card -> !Zone.EXILED.equals((Object)game.getState().getZone(card.getId())));
            if (!exiledCards.isEmpty()) {
                PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTargets(exiledCards, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.RED));
        filter.add(Predicates.or((Predicate)CardType.INSTANT.getPredicate(), (Predicate)CardType.SORCERY.getPredicate()));
    }
}

