/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBlockTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChandraPyromasterEffect1
extends OneShotEffect {
    public ChandraPyromasterEffect1() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 1 damage to target player or planeswalker and 1 damage to up to one target creature that player or that planeswalker's controller controls. That creature can't block this turn.";
    }

    private ChandraPyromasterEffect1(ChandraPyromasterEffect1 effect) {
        super((OneShotEffect)effect);
    }

    public ChandraPyromasterEffect1 copy() {
        return new ChandraPyromasterEffect1(this);
    }

    public boolean apply(Game game, Ability source) {
        game.damagePlayerOrPermanent(((Target)source.getTargets().get(0)).getFirstTarget(), 1, source.getSourceId(), source, game, false, true);
        Permanent creature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (creature != null) {
            creature.damage(1, source.getSourceId(), source, game, false, true);
            CantBlockTargetEffect effect = new CantBlockTargetEffect(Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

