/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class ChandraPyromasterEffect3
extends OneShotEffect {
    public ChandraPyromasterEffect3() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile the top ten cards of your library. Choose an instant or sorcery card exiled this way and copy it three times. You may cast the copies without paying their mana costs";
    }

    private ChandraPyromasterEffect3(ChandraPyromasterEffect3 effect) {
        super((OneShotEffect)effect);
    }

    public ChandraPyromasterEffect3 copy() {
        return new ChandraPyromasterEffect3(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        TargetCard target;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 10));
        controller.moveCardsToExile(cards.getCards(game), source, game, true, source.getSourceId(), sourceObject.getIdName());
        if (!cards.getCards((FilterCard)new FilterInstantOrSorceryCard(), game).isEmpty() && controller.chooseTarget(Outcome.PlayForFree, (Cards)cards, target = new TargetCard(Zone.EXILED, (FilterCard)new FilterInstantOrSorceryCard()), source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
            ApprovingObject approvingObject = new ApprovingObject(source, game);
            if (controller.chooseUse(this.outcome, "Cast copy 1 of " + card.getName(), source, game)) {
                Card copy1 = game.copyCard(card, source, source.getControllerId());
                game.getState().setValue("PlayFromNotOwnHandZone" + copy1.getId(), (Object)Boolean.TRUE);
                controller.cast(controller.chooseAbilityForCast(copy1, game, true), game, true, approvingObject);
                game.getState().setValue("PlayFromNotOwnHandZone" + copy1.getId(), null);
            }
            if (controller.chooseUse(this.outcome, "Cast copy 2 of " + card.getName(), source, game)) {
                Card copy2 = game.copyCard(card, source, source.getControllerId());
                game.getState().setValue("PlayFromNotOwnHandZone" + copy2.getId(), (Object)Boolean.TRUE);
                controller.cast(controller.chooseAbilityForCast(copy2, game, true), game, true, approvingObject);
                game.getState().setValue("PlayFromNotOwnHandZone" + copy2.getId(), null);
            }
            if (controller.chooseUse(this.outcome, "Cast copy 3 of " + card.getName(), source, game)) {
                Card copy3 = game.copyCard(card, source, source.getControllerId());
                game.getState().setValue("PlayFromNotOwnHandZone" + copy3.getId(), (Object)Boolean.TRUE);
                controller.cast(controller.chooseAbilityForCast(copy3, game, true), game, true, approvingObject);
                game.getState().setValue("PlayFromNotOwnHandZone" + copy3.getId(), null);
            }
            return true;
        }
        return false;
    }
}

