/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class ChandraPyromasterTarget
extends TargetPermanent {
    public ChandraPyromasterTarget() {
        super(0, 1, (FilterPermanent)new FilterCreaturePermanent("creature that the targeted player or planeswalker's controller controls"), false);
    }

    private ChandraPyromasterTarget(ChandraPyromasterTarget target) {
        super((TargetPermanent)target);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        Player needPlayer = game.getPlayerOrPlaneswalkerController(source.getFirstTarget());
        if (needPlayer != null) {
            possibleTargets.removeIf(id -> {
                Permanent permanent = game.getPermanent(id);
                return permanent == null || permanent.getId().equals(source.getFirstTarget()) || !permanent.isControlledBy(needPlayer.getId());
            });
        }
        return possibleTargets;
    }

    public ChandraPyromasterTarget copy() {
        return new ChandraPyromasterTarget(this);
    }
}

