/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.command.Emblem;
import mage.game.command.emblems.ChandraRoaringFlameEmblem;
import mage.players.Player;

class ChandraRoaringFlameEmblemEffect
extends OneShotEffect {
    ChandraRoaringFlameEmblemEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 6 damage to each opponent. Each player dealt damage this way gets an emblem with \"At the beginning of your upkeep, this emblem deals 3 damage to you.\"";
    }

    private ChandraRoaringFlameEmblemEffect(ChandraRoaringFlameEmblemEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraRoaringFlameEmblemEffect copy() {
        return new ChandraRoaringFlameEmblemEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<Player> opponentsEmblem = new ArrayList<Player>();
        for (UUID playerId : game.getOpponents(controller.getId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null || opponent.damage(6, source, game) <= 0) continue;
            opponentsEmblem.add(opponent);
        }
        for (Player opponent : opponentsEmblem) {
            game.addEmblem((Emblem)new ChandraRoaringFlameEmblem(), source.getSourceObject(game), opponent.getId());
        }
        return false;
    }
}

