/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.c.ChandrasIncineratorWatcher;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class ChandrasIncineratorCostReductionEffect
extends CostModificationEffectImpl {
    ChandrasIncineratorCostReductionEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "This spell costs {X} less to cast, where X is the total amount of noncombat damage dealt to your opponents this turn";
    }

    private ChandrasIncineratorCostReductionEffect(ChandrasIncineratorCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        ChandrasIncineratorWatcher watcher = (ChandrasIncineratorWatcher)game.getState().getWatcher(ChandrasIncineratorWatcher.class);
        if (watcher == null) {
            return true;
        }
        int reductionAmount = watcher.getDamage(source.getControllerId());
        CardUtil.reduceCost((Ability)abilityToModify, (int)Math.max(0, reductionAmount));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId()) && game.getCard(abilityToModify.getSourceId()) != null;
    }

    public ChandrasIncineratorCostReductionEffect copy() {
        return new ChandrasIncineratorCostReductionEffect(this);
    }
}

