/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.ChaosDragonRestrictionEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ChaosDragonEffect
extends OneShotEffect {
    ChaosDragonEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player rolls a d20. If one or more opponents had the highest result, {this} can't attack those players or planeswalkers they control this combat";
    }

    private ChaosDragonEffect(ChaosDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChaosDragonEffect copy() {
        return new ChaosDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<Integer, Set> playerMap = new HashMap<Integer, Set>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) {
                return false;
            }
            playerMap.computeIfAbsent(player.rollDice(this.outcome, source, game, 20), x -> new HashSet()).add(playerId);
        }
        int max = playerMap.keySet().stream().mapToInt(x -> x).max().orElse(0);
        game.addEffect((ContinuousEffect)new ChaosDragonRestrictionEffect((Set)playerMap.get(max)), source);
        return true;
    }
}

