/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;

class ChaosMutationEffect
extends OneShotEffect {
    ChaosMutationEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile any number of target creatures controlled by different players. For each creature exiled this way, its controller reveals cards from the top of their library until they reveal a creature card, puts that card onto the battlefield, then puts the rest on the bottom of their library in a random order";
    }

    private ChaosMutationEffect(ChaosMutationEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChaosMutationEffect copy() {
        return new ChaosMutationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Set permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (controller == null || permanents.isEmpty()) {
            return false;
        }
        List players = permanents.stream().map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        controller.moveCards(permanents, Zone.EXILED, source, game);
        game.processAction();
        for (Player player : players) {
            CardsImpl cards = new CardsImpl();
            Card card = ChaosMutationEffect.getCreatureCard(player, (Cards)cards, game);
            player.revealCards(source, (Cards)cards, game);
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
            cards.retainZone(Zone.LIBRARY, game);
            player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        return true;
    }

    private static Card getCreatureCard(Player player, Cards cards, Game game) {
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (!card.isCreature(game)) continue;
            return card;
        }
        return null;
    }
}

