/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class ChaosOrbEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("nontoken permanent");

    ChaosOrbEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "if {this} is on the battlefield, choose a nontoken permanent, then a number between 1 and 20 is generated at random. If the number is 4 or more, destroy the chosen permanent";
    }

    private ChaosOrbEffect(ChaosOrbEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChaosOrbEffect copy() {
        return new ChaosOrbEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent orb = source.getSourcePermanentIfItStillExists(game);
        if (player == null || orb == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        Permanent chosen = null;
        if (target.choose(this.outcome, player.getId(), source.getSourceId(), source, game)) {
            chosen = game.getPermanent(target.getFirstTarget());
        }
        if (chosen != null) {
            game.informPlayers(player.getLogName() + " has chosen " + chosen.getLogName() + CardUtil.getSourceLogName((Game)game, (Ability)source));
            int result = player.rollDieResult(20, game);
            game.informPlayers("The random number is " + result + CardUtil.getSourceLogName((Game)game, (Ability)source));
            if (result >= 4) {
                chosen.destroy(source, game);
            }
        }
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

