/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ChaosWandEffect
extends OneShotEffect {
    ChaosWandEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Target opponent exiles cards from the top of their library until they exile an instant or sorcery card. You may cast that card without paying its mana cost. Then put the exiled cards that weren't cast this way on the bottom of that library in a random order.";
    }

    private ChaosWandEffect(ChaosWandEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChaosWandEffect copy() {
        return new ChaosWandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        CardsImpl cardsToShuffle = new CardsImpl();
        while (opponent.canRespond() && opponent.getLibrary().hasCards() && (card = opponent.getLibrary().getFromTop(game)) != null) {
            cardsToShuffle.add(card);
            opponent.moveCards(card, Zone.EXILED, source, game);
            if (!card.isInstantOrSorcery(game)) continue;
            CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)card);
            break;
        }
        cardsToShuffle.retainZone(Zone.EXILED, game);
        controller.revealCards(source, (Cards)cardsToShuffle, game);
        return opponent.putCardsOnBottomOfLibrary((Cards)cardsToShuffle, game, source, false);
    }
}

