/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterPermanentCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChaosWarpRevealEffect
extends OneShotEffect {
    ChaosWarpRevealEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = ", then reveals the top card of their library. If it's a permanent card, they put it onto the battlefield";
    }

    private ChaosWarpRevealEffect(ChaosWarpRevealEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChaosWarpRevealEffect copy() {
        return new ChaosWarpRevealEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Permanent permanent = (Permanent)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.BATTLEFIELD);
        if (permanent == null) {
            return false;
        }
        Player owner = game.getPlayer(permanent.getOwnerId());
        MageObject sourceObject = game.getObject(source);
        if (owner == null || sourceObject == null) {
            return false;
        }
        if (owner.getLibrary().hasCards() && (card = owner.getLibrary().getFromTop(game)) != null) {
            CardsImpl cards = new CardsImpl(card);
            owner.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            if (new FilterPermanentCard().match(card, game)) {
                owner.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
        }
        return true;
    }
}

