/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChaosWarpShuffleIntoLibraryEffect
extends OneShotEffect {
    ChaosWarpShuffleIntoLibraryEffect() {
        super(Outcome.Detriment);
        this.staticText = "The owner of target permanent shuffles it into their library";
    }

    private ChaosWarpShuffleIntoLibraryEffect(ChaosWarpShuffleIntoLibraryEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChaosWarpShuffleIntoLibraryEffect copy() {
        return new ChaosWarpShuffleIntoLibraryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player owner;
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && (owner = game.getPlayer(permanent.getOwnerId())) != null) {
            owner.moveCardToLibraryWithInfo((Card)permanent, source, game, Zone.BATTLEFIELD, true, true);
            owner.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

