/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class ChaoticBacklashEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("white and/or blue permanents they control");

    public ChaoticBacklashEffect() {
        super(Outcome.Detriment);
        this.staticText = "{this} deals damage to target player equal to twice the number of white and/or blue permanents they control";
    }

    private ChaoticBacklashEffect(ChaoticBacklashEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChaoticBacklashEffect copy() {
        return new ChaoticBacklashEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer != null) {
            int amount = 2 * game.getBattlefield().countAll(filter, targetPlayer.getId(), game);
            targetPlayer.damage(amount, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)new ColorPredicate(ObjectColor.WHITE), (Predicate)new ColorPredicate(ObjectColor.BLUE)));
    }
}

