/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.IxalanVampireToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class CharismaticConquerorEffect
extends OneShotEffect {
    CharismaticConquerorEffect() {
        super(Outcome.Benefit);
        this.staticText = "they may tap that permanent. If they don't, you create a 1/1 white Vampire creature token with lifelink.";
    }

    private CharismaticConquerorEffect(CharismaticConquerorEffect effect) {
        super((OneShotEffect)effect);
    }

    public CharismaticConquerorEffect copy() {
        return new CharismaticConquerorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && game.getPlayer(permanent.getControllerId()) != null) {
            Player opponent = game.getPlayer(permanent.getControllerId());
            if (!permanent.isTapped() && opponent.chooseUse(Outcome.Tap, "Tap " + permanent.getLogName(), source, game)) {
                permanent.tap(source, game);
                return false;
            }
        }
        return new CreateTokenEffect((Token)new IxalanVampireToken()).apply(game, source);
    }
}

