/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import mage.MageItem;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.ChefsKissApplier;
import mage.constants.Outcome;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.util.RandomUtil;
import mage.util.functions.StackObjectCopyApplier;

class ChefsKissEffect
extends OneShotEffect {
    ChefsKissEffect() {
        super(Outcome.Benefit);
        this.staticText = "gain control of target spell that targets only a single permanent or player. Copy it, then reselect the targets at random for the spell and the copy. The new targets can't be you or a permanent you control";
    }

    private ChefsKissEffect(ChefsKissEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChefsKissEffect copy() {
        return new ChefsKissEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObjectReferencePredicate predicate;
        ChefsKissApplier applier;
        Spell spell = game.getSpell(source.getFirstTarget());
        if (spell == null) {
            return false;
        }
        spell.setControllerId(source.getControllerId());
        ArrayList<UUID> possibleTargets = new ArrayList<UUID>((Collection<UUID>)game.getState().getPlayersInRange(source.getControllerId(), game));
        possibleTargets.remove(source.getControllerId());
        game.getBattlefield().getActivePermanents(source.getControllerId(), game).stream().filter(p -> !p.isControlledBy(source.getControllerId())).map(MageItem::getId).forEach(possibleTargets::add);
        possibleTargets.removeIf(uuid -> !spell.canTarget(game, uuid));
        if (possibleTargets.isEmpty()) {
            applier = null;
            predicate = null;
        } else {
            applier = new ChefsKissApplier((UUID)possibleTargets.get(RandomUtil.nextInt((int)possibleTargets.size())), game);
            predicate = new MageObjectReferencePredicate(new MageObjectReference((UUID)possibleTargets.get(RandomUtil.nextInt((int)possibleTargets.size())), game));
        }
        spell.createCopyOnStack(game, source, source.getControllerId(), false, 1, (StackObjectCopyApplier)applier);
        if (predicate != null) {
            spell.chooseNewTargets(game, source.getControllerId(), true, true, predicate);
        }
        return true;
    }
}

