/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.AttacksIfAbleTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChemistersTrickEffect
extends OneShotEffect {
    ChemistersTrickEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "each creature you don't control attacks this turn if able";
    }

    private ChemistersTrickEffect(ChemistersTrickEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL, source.getControllerId(), source, game)) {
            AttacksIfAbleTargetEffect effect = new AttacksIfAbleTargetEffect(Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }

    public ChemistersTrickEffect copy() {
        return new ChemistersTrickEffect(this);
    }
}

