/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ChirrutImweEffect
extends ContinuousEffectImpl {
    public ChirrutImweEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "{this} can block up to two additional creatures";
    }

    private ChirrutImweEffect(ChirrutImweEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ChirrutImweEffect copy() {
        return new ChirrutImweEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm != null) {
            switch (layer) {
                case RulesEffects: {
                    if (perm.getMaxBlocks() <= 0) break;
                    perm.setMaxBlocks(perm.getMaxBlocks() + 2);
                }
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

