/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class ChocoSeekerOfParadiseEffect
extends OneShotEffect {
    ChocoSeekerOfParadiseEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at that many cards from the top of your library. You may put one of them into your hand. Then put any number of land cards from among them onto the battlefield tapped and the rest into your graveyard";
    }

    private ChocoSeekerOfParadiseEffect(ChocoSeekerOfParadiseEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChocoSeekerOfParadiseEffect copy() {
        return new ChocoSeekerOfParadiseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int amount = (Integer)this.getValue("number_attackers");
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, amount));
        cards.retainZone(Zone.LIBRARY, game);
        if (cards.isEmpty()) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, StaticFilters.FILTER_CARD);
        target.withChooseHint("to put into your hand");
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Optional.ofNullable(target.getFirstTarget()).map(arg_0 -> ((Game)game).getCard(arg_0)).ifPresent(card -> player.moveCards(card, Zone.HAND, source, game));
        cards.retainZone(Zone.LIBRARY, game);
        target = new TargetCardInLibrary(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_LANDS);
        target.withChooseHint("to put onto the battlefield tapped");
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        player.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        cards.retainZone(Zone.LIBRARY, game);
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        return true;
    }
}

