/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChokingSandsEffect
extends OneShotEffect {
    ChokingSandsEffect() {
        super(Outcome.Damage);
        this.staticText = "If that land was nonbasic, {this} deals 2 damage to the land's controller";
    }

    private ChokingSandsEffect(ChokingSandsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChokingSandsEffect copy() {
        return new ChokingSandsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = (Permanent)game.getLastKnownInformation(source.getFirstTarget(), Zone.BATTLEFIELD);
        if (permanent != null && !permanent.isBasic(game) && (player = game.getPlayer(permanent.getControllerId())) != null) {
            player.damage(2, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

