/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.util.CardUtil;
import mage.util.GameLog;

class ChromeMoxEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("nonartifact, nonland card");

    public ChromeMoxEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile a nonartifact, nonland card from your hand";
    }

    private ChromeMoxEffect(ChromeMoxEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            TargetCard target = new TargetCard(Zone.HAND, filter);
            target.withNotTarget(true);
            Card cardToImprint = null;
            Permanent sourcePermanent = game.getPermanent(source.getSourceId());
            if (!controller.getHand().isEmpty() && controller.choose(Outcome.Benefit, (Target)target, source, game)) {
                cardToImprint = controller.getHand().get(target.getFirstTarget(), game);
            }
            if (sourcePermanent != null) {
                if (cardToImprint != null) {
                    controller.moveCardsToExile(cardToImprint, source, game, true, source.getSourceId(), sourceObject.getIdName() + " (Imprint)");
                    sourcePermanent.imprint(cardToImprint.getId(), game);
                    sourcePermanent.addInfo("imprint", CardUtil.addToolTipMarkTags((String)("[Imprinted card - " + GameLog.getColoredObjectIdNameForTooltip((MageObject)cardToImprint) + ']')), game);
                } else {
                    sourcePermanent.addInfo("imprint", CardUtil.addToolTipMarkTags((String)"[Imprinted card - None]"), game);
                }
            }
            return true;
        }
        return false;
    }

    public ChromeMoxEffect copy() {
        return new ChromeMoxEffect(this);
    }

    static {
        filter.add(Predicates.not((Predicate)Predicates.or((Predicate)CardType.LAND.getPredicate(), (Predicate)CardType.ARTIFACT.getPredicate())));
    }
}

