/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChronicFloodingAbility
extends TriggeredAbilityImpl {
    ChronicFloodingAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MillCardsTargetEffect(3));
    }

    private ChronicFloodingAbility(ChronicFloodingAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attached;
        Permanent source = game.getPermanent(this.sourceId);
        if (source != null && source.isAttachedTo(event.getTargetId()) && (attached = game.getPermanent(source.getAttachedTo())) != null) {
            for (Effect e : this.getEffects()) {
                e.setTargetPointer((TargetPointer)new FixedTarget(attached.getControllerId()));
            }
            return true;
        }
        return false;
    }

    public ChronicFloodingAbility copy() {
        return new ChronicFloodingAbility(this);
    }

    public String getRule() {
        return "Whenever enchanted land becomes tapped, its controller mills three cards.";
    }
}

