/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CindervinesEffect
extends OneShotEffect {
    CindervinesEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy target artifact or enchantment. {this} deals 2 damage to that permanent's controller.";
    }

    private CindervinesEffect(CindervinesEffect effect) {
        super((OneShotEffect)effect);
    }

    public CindervinesEffect copy() {
        return new CindervinesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null) {
            return false;
        }
        permanent.destroy(source, game, false);
        player.damage(2, source.getSourceId(), source, game);
        return true;
    }
}

