/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CircleOfSolaceEffect
extends PreventionEffectImpl {
    CircleOfSolaceEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false);
        this.staticText = "The next time a creature of the chosen type would deal damage to you this turn, prevent that damage.";
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        this.preventDamageAction(event, source, game);
        this.used = true;
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent perm;
        if (!this.used && super.applies(event, source, game) && event.getTargetId().equals(source.getControllerId()) && event.getAmount() > 0 && (perm = game.getPermanent(event.getSourceId())) != null) {
            SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
            return perm.isCreature() && perm.hasSubtype(subType, game);
        }
        return false;
    }

    private CircleOfSolaceEffect(CircleOfSolaceEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public CircleOfSolaceEffect copy() {
        return new CircleOfSolaceEffect(this);
    }
}

