/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.players.Player;

class CitadelOfPainEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledLandPermanent();

    public CitadelOfPainEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to that player, where X is the number of untapped lands they control.";
    }

    private CitadelOfPainEffect(CitadelOfPainEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            return false;
        }
        int damage = game.getBattlefield().count(filter, game.getActivePlayerId(), source, game);
        return damage > 0 && player.damage(damage, source.getSourceId(), source, game) > 0;
    }

    public CitadelOfPainEffect copy() {
        return new CitadelOfPainEffect(this);
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

