/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.cards.c.CityInABottle;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;

class CityInABottleCantPlayEffect
extends ContinuousRuleModifyingEffectImpl {
    private static final FilterCard filter = new FilterCard();

    CityInABottleCantPlayEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Players can't cast spells or play lands with a name originally printed in the <i>Arabian Nights</i> expansion";
    }

    private CityInABottleCantPlayEffect(CityInABottleCantPlayEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public CityInABottleCantPlayEffect copy() {
        return new CityInABottleCantPlayEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        return "You can't play cards with a name originally printed in the Arabian Nights expansion";
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PLAY_LAND || event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card = game.getCard(event.getSourceId());
        return filter.match(card, source.getControllerId(), source, game);
    }

    static {
        filter.add(Predicates.or(CityInABottle.ARABIAN_NIGHTS_CARD_NAME_PREDICATES));
    }
}

