/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.StateTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.c.CityInABottle;
import mage.cards.c.CityInABottleSacrificeEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;

class CityInABottleStateTriggeredAbility
extends StateTriggeredAbility {
    private static final FilterPermanent filter = new FilterPermanent("other nontoken permanents with a name originally printed in the Arabian Nights expansion");

    CityInABottleStateTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CityInABottleSacrificeEffect());
        this.setTriggerPhrase("Whenever one or more other nontoken permanents with a name originally printed in the <i>Arabian Nights</i> expansion are on the battlefield, ");
    }

    private CityInABottleStateTriggeredAbility(CityInABottleStateTriggeredAbility ability) {
        super((StateTriggeredAbility)ability);
    }

    public CityInABottleStateTriggeredAbility copy() {
        return new CityInABottleStateTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return game.getBattlefield().contains(filter, this.getControllerId(), (Ability)this, game, 1);
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
        filter.add(Predicates.or(CityInABottle.ARABIAN_NIGHTS_CARD_NAME_PREDICATES));
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

