/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class CityOfSolitudeEffect
extends ContinuousRuleModifyingEffectImpl {
    CityOfSolitudeEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Players can cast spells and activate abilities only during their own turns";
    }

    private CityOfSolitudeEffect(CityOfSolitudeEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL || event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject sourceObject = game.getObject(source);
        MageObject eventObject = game.getObject(event.getSourceId());
        if (sourceObject != null && eventObject != null) {
            return "You can cast or activate anability of " + eventObject.getIdName() + "  only during your own turns (" + sourceObject.getIdName() + "). ";
        }
        return null;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return !game.isActivePlayer(event.getPlayerId());
    }

    public CityOfSolitudeEffect copy() {
        return new CityOfSolitudeEffect(this);
    }
}

